#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/vcutm/header.h"
#include "levels/wdw/header.h"

extern u8 _vcutm_segment_ESegmentRomStart[];
extern u8 _vcutm_segment_ESegmentRomEnd[];

const LevelScript level_vcutm_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _wdw_segment_7SegmentRomStart, _wdw_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _wdwSegmentRomStart, _wdwSegmentRomEnd),
LOAD_RAW(0x0E, _vcutm_segment_ESegmentRomStart, _vcutm_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group8_mio0SegmentRomStart, _group8_mio0SegmentRomEnd),
LOAD_RAW(12, _group8_geoSegmentRomStart, _group8_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_WDW_BUBBLY_TREE,                   bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(MODEL_WDW_SQUARE_FLOATING_PLATFORM,      wdw_geo_000580),
LOAD_MODEL_FROM_GEO(MODEL_WDW_ARROW_LIFT,                    wdw_geo_000598),
LOAD_MODEL_FROM_GEO(MODEL_WDW_WATER_LEVEL_DIAMOND,           wdw_geo_0005C0),
LOAD_MODEL_FROM_GEO(MODEL_WDW_HIDDEN_PLATFORM,               wdw_geo_0005E8),
LOAD_MODEL_FROM_GEO(MODEL_WDW_EXPRESS_ELEVATOR,              wdw_geo_000610),
LOAD_MODEL_FROM_GEO(MODEL_WDW_RECTANGULAR_FLOATING_PLATFORM, wdw_geo_000628),
LOAD_MODEL_FROM_GEO(MODEL_WDW_ROTATING_PLATFORM,             wdw_geo_000640),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(84, 0x05002e00, 4),
// LOAD_MODEL_FROM_DL(86, 0x05003120, 4),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_9),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_vcutm_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_vcutm_1_[] = {
AREA(1, Geo_vcutm_1_0x1ae30a0),
TERRAIN(col_vcutm_1_0xe02f410),
SET_BACKGROUND_MUSIC(0, 43),
TERRAIN_TYPE(3),
JUMP_LINK(local_objects_vcutm_1_),
JUMP_LINK(local_warps_vcutm_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_vcutm_1_[] = {
OBJECT_WITH_ACTS(0, 5652, 1379, 5328, 0, 180, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(124, 5170, 867, 4919, 0, 180, 0, 0xa50000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(124, 2159, -4680, 532, 0, 18, 0, 0x9f0000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(56, 4075, 712, 4702, 0, 0, 0, 0x0,  bhvWaterLevelDiamond, 31),
OBJECT_WITH_ACTS(56, 1978, -4680, 2969, 0, 0, 0, 0x0,  bhvWaterLevelDiamond, 31),
OBJECT_WITH_ACTS(137, 2363, -4424, 641, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 4250, 888, 4324, 0, 0, 0, 0x0,  bhvInitializeChangingWaterLevel, 31),
OBJECT_WITH_ACTS(137, 2805, 3413, -1642, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 1976, -4456, 2969, 0, 0, 0, 0x0,  bhvInitializeChangingWaterLevel, 31),
OBJECT_WITH_ACTS(56, 2042, -9970, 2928, 0, 0, 0, 0x0,  bhvWaterLevelDiamond, 31),
OBJECT_WITH_ACTS(0, 2042, -9745, 2928, 0, 0, 0, 0x0,  bhvInitializeChangingWaterLevel, 31),
OBJECT_WITH_ACTS(22, 2231, -9970, 1220, 0, 0, 0, 0x10000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(22, -1146, 3086, 4834, 0, 0, 0, 0x20000,  bhvWarpPipe, 31),
OBJECT_WITH_ACTS(137, 2683, -156, 5694, 0, 0, 0, 0x80000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 3570, -4453, -3302, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -6909, 1273, -3158, 0, 270, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 1991, -5120, 2949, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, -2404, 2360, 113, 0, 0, 0, 0x5080000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 4895, 3013, 2455, 0, 0, 0, 0x4000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(217, 1837, -5033, 2795, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 2144, -5033, 2795, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 1837, -5033, 3104, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 2144, -5033, 3103, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(120, -682, -9152, 4198, 0, 284, 0, 0x0,  bhvRecoveryHeart, 31),
OBJECT_WITH_ACTS(0, 1976, -4456, 2972, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2042, -9745, 2928, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(137, -2691, 2233, -2842, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(215, 6250, 2607, 1156, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, 393, 3457, 2411, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(215, 1184, 3698, 5060, 0, 61, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3418, -1852, 5109, 0, 61, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(85, 3395, 3648, 4464, 0, 0, 0, 0x20000,  bhvCapSwitch, 31),
OBJECT_WITH_ACTS(180, 610, -615, 4699, 0, 324, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, 3800, 3157, -534, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 376, 3457, 3193, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 593, 1707, 3564, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 2805, 3157, -1642, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 1145, 1707, 2337, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(215, 390, 357, 2007, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2667, -5502, -4153, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 182, -3682, -3063, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2796, 2607, -534, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1287, -9203, -2131, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, 1809, -9714, 1395, 0, 0, 0, 0x6000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(0, 4650, 1888, 4605, 0, 167, 0, 0x30000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, 1978, -4680, 2969, 0, 0, 0, 0x40000,  bhvFadingWarp, 31),
OBJECT_WITH_ACTS(0, 3800, 3157, -534, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, 376, 3457, 3193, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, 593, 1707, 3564, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, 2805, 3157, -1642, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, 1145, 1707, 2337, 0, 0, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(137, -3613, -4466, -2395, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(212, 1223, -2386, 918, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(137, 2731, 4007, -868, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(212, -3100, 2615, 145, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, -3500, 2615, 145, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(212, -3300, 2615, 145, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, -3051, 3086, 2935, 0, 355, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(212, 5528, 3136, -4316, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 4356, 3086, -4256, 0, 9095, 0, 0x0,  bhvCoinFormation, 31),
RETURN()
};

const LevelScript local_warps_vcutm_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(2, 18, 1, 1, 0),
WARP_NODE(1, 18, 1, 2, 0),
WARP_NODE(3, 18, 1, 4, 0),
WARP_NODE(4, 18, 1, 3, 0),
WARP_NODE(240, 6, 2, 46, 0),
WARP_NODE(241, 6, 2, 56, 0),
RETURN()
};
